<?php
/* Check cookie against URL */
$table = $_GET['t'];
if(!$_COOKIE || $_COOKIE['MJ_Session'] != $table) header('Location: index.php');

include('classes.inc.php');
include('helpers.inc.php');
include('header.inc.php');

/* # ############################# # */
/*
 * If there's no mahjong, offer a solution
 */
if(!isset($_POST['mahjong'])) {
	include('no_mahjong.inc.php');
	die();
}


$error = '';
/* echo "<pre>";
print_r($_POST);
echo "</pre>";
echo '<hr>'; */

/* # ############################# # */
/*
 * Grab names and IDs from the database
 * and create Player Objects.
 */
$db = MyDB();
$result = $db->query("SELECT id, name, score, wind_current AS wind FROM $table");
$i = 1;
while($row = $result->fetch_array(MYSQLI_ASSOC))
{
	if($_POST['mahjong'] == $i) {
		${'p' . $i } = new Player($row['id'], $row['name'], $row['score'], $row['wind'], TRUE);
	}
	else {
		${'p' . $i } = new Player($row['id'], $row['name'], $row['score'], $row['wind']);
	}
	$i++;
}
$player_list = [$p1, $p2, $p3, $p4];

/*
 * Fill the Player Objects with the appropriate POST-Data
 */
foreach($player_list as $p) {
	// Add up stuff
	$num_pongs = $_POST['p'.$p->id.'_pongs_amount'];
	$p->num_pongs = $num_pongs;
	$num_kongs = $_POST['p'.$p->id.'_kongs_amount'];
	$p->num_kongs = $num_kongs;
	$p->num_chows = $p->calculateChows();
	$p->manually_entered_points = $_POST['p'.$p->id.'_manually_entered_points'];
	// Inspect the Pongs and Kongs
	for($j=1; $j<$num_pongs+1; $j++) {
		$p->pongs[$j] = details('pong', $p->id, $j);
	}
	for($j=1; $j<$num_kongs+1; $j++) {
		$p->kongs[$j] = details('kong', $p->id, $j);
	}
	// Own Wind-Pong/Kong
	$p->own_wind_pong = isset($_POST['p'.$p->id.'_own_wind_pong']) ? true : false;
	$p->own_wind_kong = isset($_POST['p'.$p->id.'_own_wind_kong']) ? true : false;
	// Flowers
	$p->num_flowers = $_POST['flowers_'.$p->id];
	$p->num_own_flowers = $_POST['own_flowers_'.$p->id];
	$p->flower_sequence = isset($_POST['flower_sequence_'.$p->id]) ? true : false;
	// Set Bonuses for the winning hand
	if($p->mj) {
		// Colormix
		$p->mj_color = $_POST['p'.$p->id.'_color'];
		// Hand
		$p->mj_hand = (isset($_POST['mj_hand_'.$p->id])) ? true : false;
		// Pair of own winds
		$p->mj_own_pair = (isset($_POST['mj_pair_'.$p->id])) ? true : false;
		// Pair of dragons
		$p->mj_dragon_pair = (isset($_POST['mj_dragon_pair_'.$p->id])) ? true : false;
		// MJ mit Ersatzstein
		$p->mj_after_flower = (isset($_POST['mj_after_flower_'.$p->id])) ? true : false;
		// MJ with first discarded tile
		$p->mj_no_draw = (isset($_POST['mj_no_draw_'.$p->id])) ? true : false;
		// MJ with last tile in the wall
		$p->mj_last_tile = (isset($_POST['mj_last_tile_'.$p->id])) ? true : false;
	}
}

include('validation.inc.php');

/* # ############################# #
 *
 * Calculate Hand-Points
 */
foreach($player_list as $p) {
	if($p->mj) {
		// Base points for Mahjong in Pong/Chow/Kong
		if($p->num_chows == 4 or $p->num_pongs == 4) {
			$p->base_points = 30;
			$p->bp_explanation .= '<li>Mahjong in Pong/Chow: 30</li>';
		}
		elseif($p->num_kongs == 4) {
			$p->base_points = 60;
			$p->bp_explanation .= '<li>Mahjong in Kong: 60</li>';
		}
		else {
			$p->base_points = 20;
			$p->bp_explanation .= '<li>Mahjong: 20</li>';
		}
		// Base point bonuses for MJ with flower replacement tile, with hidden hand, or with last tile in wall
		if($p->mj_hand) {
			$p->base_points = $p->base_points + 10;
			$p->bp_explanation .= '<li>Mahjong aus der Hand: +10</li>';
		}
		if($p->mj_after_flower) {
			$p->base_points = $p->base_points + 10;
			$p->bp_explanation .= '<li>Mahjong mit Ersatzstein: +10</li>';
		}
		// Last tile in the wall
		if($p->mj_last_tile) {
			$p->base_points = $p->base_points + 10;
			$p->bp_explanation .= '<li>Mahjong mit letztem Mauerstein: +10</li>';
		}
		// Own-Wind-Pair or Dragon-Pair
		if($p->mj_own_pair || $p->mj_dragon_pair) {
			$p->base_points = $p->base_points + 2;
			$p->bp_explanation .= '<li>Eigenes Windpaar oder Drachenpaar: +2</li>';
		}
	}
	// Add Flowers
	if($p->num_flowers > 0) {
		$p->base_points = $p->base_points + $p->num_flowers * 4;
		$p->bp_explanation .= '<li>'.$p->num_flowers.' Blumen/Jahreszeiten je +4</li>';
	}
	// Add Pongs
	if($p->num_pongs >0) {
		foreach($p->pongs as $pong) {
			$pong_multiplier = 1;
			$pong_name = 'Pong';
			if($pong['hidden']) {
				$pong_multiplier = $pong_multiplier*2;
				$pong_name .= ', verdeckt';
			}
			if($pong['corner']) {
				$pong_multiplier = $pong_multiplier*2;
				$pong_name = 'Rand-'.$pong_name;
			}
			elseif($pong['trump']) {
				$pong_multiplier = $pong_multiplier*2;
				$pong_name = 'Trumpf-'.$pong_name;
				$p->pong_t += 1;
			}
			$pong_value = $pong_multiplier*2;
			$p->base_points = $p->base_points + $pong_value;
			$p->bp_explanation .= '<li>'.$pong_name.' +'.$pong_value.'</li>';
		}
	}
	// Add Kongs
	if($p->num_kongs >0) {
		foreach($p->kongs as $kong) {
			$kong_multiplier = 1;
			$kong_name = 'Kong';
			if($kong['hidden']) {
				$kong_multiplier = $kong_multiplier*2;
				$kong_name .= ', verdeckt';
			}
			if($kong['corner']) {
				$kong_multiplier = $kong_multiplier*2;
				$kong_name = 'Rand-'.$kong_name;
			}
			elseif($kong['trump']) {
				$kong_multiplier = $kong_multiplier*2;
				$kong_name = 'Trumpf-'.$kong_name;
				$p->kong_t += 1;
			}
			$kong_value = $kong_multiplier*4;
			$p->base_points = $p->base_points + $kong_value;
			$p->bp_explanation .= '<li>'.$kong_name.' +'.$kong_value.'</li>';
		}
	}
	// Add Pair
	if(isset($p->own_pair)) {
		$p->base_points = $p->base_points +2;
		$p->bp_explanation .= '<li>Eigenes Windpaar +2</li>';
	}


	/*
	 * Hand-Multiplier
	 */
	if($p->mj) {
		if($p->mj_color == 1) {
			$p->multiplier = $p->multiplier * 2;
			$p->m_explanation .= '<li>Mahjong Einfarbig +1</li>';
		}
		elseif($p->mj_color == 2) {
			$p->multiplier = $p->multiplier * 8;
			$p->m_explanation .= '<li>Mahjong Reinfarbig +3</li>';
		}
		elseif($p->kong_t + $p->pong_t == 4 && ($p->mj_own_pair || $p->mj_dragon_pair)) {
			$p->multiplier = $p->multiplier * 16;
			$p->m_explanation .= '<li>Reines Trumpfspiel +4</li>';
		}
	}
	// Own Flowers
	if($p->num_own_flowers > 0) {
		for($i=1; $i<=$p->num_own_flowers; $i++) {
			$p->multiplier = $p->multiplier * 2;
		}
		$p->m_explanation .= '<li>Eigene Blume/Jahreszeit +1</li>';
	}
	if($p->num_flowers == 8) {
		$p->multiplier *= 16;
		$p->m_explanation .= '<li>Zwei Sträuße +6</li>';
	}
	elseif($p->num_flowers > 3 && $p->num_own_flowers > 0 && $p->flower_sequence) {
		$p->multiplier *= 8;
		$p->m_explanation .= '<li>Strauß +3</li>';
	}
	// Kongs
	if($p->num_kongs > 0) {
		for($i=1; $i<=$p->num_kongs; $i++) {
			$p->multiplier = $p->multiplier * 2;
			if($p->kongs[$i]['trump']) {
				$p->multiplier = $p->multiplier * 2;
				$p->m_explanation .= '<li>Trumpf-Kong +2</li>';
			}
			else $p->m_explanation .= '<li>Kong +1</li>';
		}
	}
	// Trump Pongs and 3 hidden Pongs
	if($p->num_pongs > 0) {
		$hidden_pongs = 0;
		for($i=1; $i<=$p->num_pongs; $i++) {
			if($p->pongs[$i]['trump']) {
				$p->multiplier = $p->multiplier * 2;
				$p->m_explanation .= '<li>Trumpfpong +1</li>';
			}
			if($p->pongs[$i]['hidden']) $hidden_pongs++;
		}
		if($hidden_pongs > 2) {
			$p->multiplier = $p->multiplier * 8;
			$p->m_explanation .= '<li>Drei verdeckte Pongs +3</li>';
		}
	}
	if($p->own_wind_pong) {
		$p->multiplier = $p->multiplier * 2;
		$p->m_explanation .= '<li>Eigener Windpong +1</li>';
	}
	if($p->own_wind_kong) {
		$p->multiplier = $p->multiplier * 2;
		$p->m_explanation .= '<li>Eigener Windkong +1</li>';
	}
	// Own-Wind-pair
	if($p->mj && $p->mj_own_pair) {
		$p->multiplier = $p->multiplier * 2;
		$p->m_explanation .= '<li>Eigenes Windpaar +1</li>';
	}
	// Multiply
	$p->hand_score = $p->base_points * $p->multiplier;
}


/*
 * Overwrite everything if points were entered manually
 */
foreach($player_list as $p) {
	if($p->manually_entered_points > 0) {
		$p->base_points = $p->hand_score = $p->manually_entered_points;
		$p->bp_explanation = '<li>Sonderspiel</li>';
		$p->m_explanation = '';
		$p->multiplier = 1;
	}
}

/* # ############################# #
 *
 * Calculate New Score
 */
$winner = $player_list[$_POST['mahjong']-1];
if($winner->wind_current == 0) $winner->result = $winner->score + ($winner->hand_score * 6);
else $winner->result = $winner->score + ($winner->hand_score * 4);

$loser_list = $player_list;
unset($loser_list[$_POST['mahjong']-1]);

foreach($loser_list as $p) {
	// pay to Winner
	if($winner->wind_current == 0 || $p->wind_current == 0) $p->temp_result = 0 - 2*$winner->hand_score;
	else $p->temp_result = 0 - $winner->hand_score;
	// pay to others
	foreach($loser_list as $x) {
		if($x->id != $p->id) {
			$diff = $p->hand_score - $x->hand_score;
			if($p->wind_current == 0 || $x->wind_current == 0) $diff = $diff * 2;
			$p->temp_result = $p->temp_result + $diff;
		}
	}
	$p->result = $p->score + $p->temp_result;
}

/*
 * Decide whether or not to change winds
 */
$windchange = ($winner->wind_current == 0) ? 0 : 1;

/*
 * Output
 */
include('calc_output.inc.php');

?>
