<?php
include('cookie.inc.php');
include('helpers.inc.php');
include('header.inc.php');

$db = myDB($table);
$result = $db->query("SELECT * FROM $table");
  while($row = $result->fetch_assoc()) {
		$p[] = $row;
	}
$sum = $db->query("SELECT SUM(times_won) AS 'total' FROM $table");
$row = mysqli_fetch_row($sum);
$sum_of_games = $row[0];

/*
 * Assign Trophies:
 * Order the player array to find the lowest/highest value
 */
// Order by Kongs
usort($p, function($a, $b) {
	return $b['total_kongs'] - $a['total_kongs'];
});
if($p[0]['total_kongs'] > 1) $p[0]['trophies'][] = 'most_kongs';

// Order by Pongs
usort($p, function($a, $b) {
	return $a['total_pongs'] - $b['total_pongs'];
});
$p[0]['trophies'][] = 'least_pongs';

// Order by Flowers
usort($p, function($a, $b) {
	return $b['total_flowers'] - $a['total_flowers'];
});
if($p[0]['total_flowers'] > 0) $p[0]['trophies'][] = 'most_flowers';

// Order by Number of Wins
usort($p, function($a, $b) {
	return $b['times_won'] - $a['times_won'];
});
if($p[0]['times_won'] > 0) $p[0]['trophies'][] = 'most_wins';
$p[3]['trophies'][] = 'no_mj';

$json = json_decode(file_get_contents('./trophies.json'), true);

/*
 * Prepare the Stairs
 * and the rest of the Presentation
 */
// Order by Total Score
usort($p, function($a, $b) {
	return $b['score'] - $a['score'];
});
if($p[1]['score'] < 0) {
	$p[0]['trophies'][] = 'sole_positive';
}
elseif($p[2]['score'] > 0) {
	$p[3]['trophies'][] = 'sad';
}

// Prepare Scaling of stairs
$range = $p[0]['score'] - $p[3]['score'];
for($i=0; $i<4; $i++) {
	$p[0]['winner'] = true;
	$p[$i]['shifted_points'] = $p[$i]['score'] + (0 - $p[3]['score']);
	$p[$i]['scaled_points'] = $p[$i]['shifted_points'] / max($range, 1);
	$p[$i]['scale'] = floor(200 * $p[$i]['scaled_points']);
}


/*
 * Output
 */
?>
<main id="tally">
<h2>Glückwunsch, <?=$p[0]['name']?></h2>
<p>Du bekommst den Finger!</p>

<?php
// Reorder by ID
usort($p, function($a, $b) {
		return $a['id'] - $b['id'];
});
?>
<table id="result">
  <?php if($sum_of_games > 0) { ?>
	<thead>
		<tr id="stairs">
			<?php foreach ($p as $player) { ?>
				<td>
					<h2<?php if(isset($player['winner'])) echo " class=\"winner\"";?>><?=$player['name']?></h2>
					<div class="stairs" style="margin-top: <?=230-$player['scale']?>px; height: <?=$player['scale']+30?>px">
						<?=formatScore($player['score'])?>
						<div>
							<ul>
								<li><?=$player['times_won']?> mal Mahjong gelegt</li>
								<li>Insgesamt <?=$player['total_pongs']?> Pongs gesammelt</li>
								<?php if($player['total_pongs'] > 0) { ?>
									<li>davon <?=($player['total_trump_pongs']) == 0 ? 'keinen einzigen' : $player['total_trump_pongs']?> <?=pluralize('Trumpf-Pong', $player['total_trump_pongs'])?></li>
								<?php } ?>
								<li>Insgesamt <?=$player['total_kongs']?> <?=pluralize('Kong')?> gesammelt</li>
								<?php if($player['total_kongs'] > 0) { ?>
									<li>davon <?=($player['total_trump_kongs']) == 0 ? 'keinen einzigen' : $player['total_trump_kongs']?> <?=pluralize('Trumpf-Kong', $player['total_trump_kongs'])?></li>
								<?php } ?>
								<li><?=$player['total_flowers']?> Blumen und Jahreszeiten gefischt</li>
                <?php if($player['total_flowers'] > 0) { ?>
								  <li> Davon <?=$player['total_own_flowers']?> Eigene</li>
                <?php } ?>
							</ul>
						</div>
					</div>
				</td>
			<?php }?>
		</tr>
  </thead>
  <tr id="trophies">
		<?php foreach($p as $player) { ?>
			<td>
				<?php if(isset($player['trophies'])) { ?>
					<ul>
					<?php foreach ($player['trophies'] as $trophy) { ?>
						<li class="trophy <?=$trophy?>">
							.
							<span><?=$json[$trophy]['title']?>: <?=$json[$trophy]['descr']?></span>
						</li>
					<?php } ?>
				<?php } ?>
		</td>
		<?php } ?>
	</tr>
  <?php } ?>
  <tr>
    <td colspan="4">
      <?=$sum_of_games?> Hände gespielt.
    </td>
  </tr>
	<tr>
		<td colspan="4">
			<input type="button" onclick="newGame('<?=$table?>')" value="Neues Spiel">
		</td>
	</tr>
</table>
</main>
