<?php

function MyDB() {
	$length = strlen('/~aw/mahjong');
	if(substr($_SERVER['PHP_SELF'], 0, $length) == '/~aw/mahjong') {
		return(new mysqli("localhost", "aw", "brandt", "mahjong"));
	}
	else {
		return(new mysqli("localhost", "d02ef5c3", "uDdJfLgUpngAnu4F", "d02ef5c3"));
	}
}


/*
 * Roll the Dice to determine the wall to deal from
 */
function rollWallDice($playername) {
	$die1 = rand(1,6);
	$die2 = rand(1,6);
	$html =  "<div class=\"diceroll\" title=\"$playername würfelt $die1 für die Mauer und eine $die2\">";
	$html .= "<span class=\"roll$die1 walldie\">$die1</span>";
	$html .= "<span class=\"roll$die2\">$die2</span></div>";
	return $html;
}
/*
 * Create Unicode Character for East/South/West/North
 */
function getWindEntity($wind) {
	return("&#x1F00$wind;");
}


/*
 * Merge information about a Pong/Kong
 * Pongs/Kongs will be arrays of Boolean values
 */
function details($type, $player, $id) {
	$a = ['hidden' => false, 'corner' => false, 'trump' => false];
	$string = 'p' . $player . '_' . $type . $id;
	if(isset($_POST[$string.'_hidden'])) $a['hidden'] = true;
	if(isset($_POST[$string.'_corner'])) $a['corner'] = true;
	elseif(isset($_POST[$string.'_trump'])) $a['trump'] = true;
	return $a;
}


/*
 * Style a number accoring to its value
 */
function formatScore($score) {
	if($score > 0) $class="positive";
	elseif($score < 0) $class="negative";
	else $class="neutral";
	return('<span class="'.$class.'">'.$score.'</span>');
}


/*
 * Style the name of the winner
 */
function formatName($player) {
	if($player->mj) return('<h2 class="winner"><span>'.getWindEntity($player->wind_current).'</span>'.$player->name.'</h2>');
	else return('<h2><span>'.getWindEntity($player->wind_current).'</span>'.$player->name.'</h2>');
}

/*
 *
 */
function pluralize($string, $amount = 2) {
	switch($amount) {
		case 0:
			return($string);
			break;
		case 1:
			return($string);
			break;
		default: return($string.'s');
	}
}

?>
