/*
 * Disable input elements that are mutually exclusive
 * like e.g. corner pong and wind pong
 */
function checkMutuallyExclusiveButtons(a, b) {
	if(document.getElementById(a).checked) {
		// Disable B
		document.getElementById(b).disabled = true;
	}
	else if(document.getElementById(a).checked == false) {
		// Enable B
		document.getElementById(b).disabled = false;
	}
	if(document.getElementById(b).checked) {
		// Disable A
		document.getElementById(a).disabled = true;
	}
	else if(document.getElementById(b).checked == false) {
		// Enable A
		document.getElementById(a).disabled = false;
	}
}


/*
 * Collapse all areas
 */
function collapseAll() {
	elements = [];
	for(i=1;i<5;i++) {
		for(j=1;j<5;j++) {
			elements.push('p' + i + '_num_pongs_' + j);
			elements.push('p' + i + '_num_kongs_' + j);
		}
		elements.push('ownflowers_' + i);
	}
	elements.forEach(function(item) {
		document.getElementById(item).style.display = 'none';
	});
}


/*
 * Check all counter areas
 */

/*
 * Show/Hide inputs with details related to Pongs/Kongs
 * Show one element per Pong/Kong
 */
function expandArea(area, input) {
	// expand how far?
	var amount = Number(document.getElementById(input).value);
	// show elements up to amount
	if(amount > 0){
		for(i=1; i<=amount; i++) {
			identifier = area+'_'+i;
			document.getElementById(identifier).style.display = 'block';
		}
	}
	// hide elements after amount
	for(i=amount+1; i<5; i++) {
		identifier = area+'_'+i;
		document.getElementById(identifier).style.display = 'none';
	}
}

/*
 * Show/Hide checkbox for special case pong/kong in own wind
 */
function toggleOwnWindCheckbox(char, player) {
	notchar = (char == 'p') ? 'k' : 'p';
	trumps = 0;
	for(i=1; i<5; i++) {
		source_id = 'p'+player+'_'+char+'ong'+i+'_trump';
		element = document.getElementById(source_id);
		if(element.checked) {
			trumps++;
			break;
		}
	}
	bonus_box_id = 'p'+player+'_own_wind_'+char+'ong';
	bonus_checkbox = bonus_box_id+'_d';
	if(trumps > 0) {
		document.getElementById(bonus_box_id).style.display = 'block';
	}
	else {
		document.getElementById(bonus_box_id).style.display = 'none';
		document.getElementById(bonus_checkbox).checked = false;
	}
}


/*
 * Show/Hide Area for bonuses related to wining a hand
 */
function expandMahjongArea(id) {
	for(i=1; i<5; i++) {
		// hide all
		document.getElementById('p'+i+'_specials').style.display = 'none';
	}
	//show the one
	document.getElementById('p'+id+'_specials').style.display = 'block';
}

/*
 * Restrict the Kong and Pong sliders to a sum of 4
 * Change the "max" value for both sliders to
 * 4-(value1 + value2)
 * Only on the current slider-pair/current player
 */
function restrictPongsAndKongs(this_slider_id) {
	// this_slider is a string, id of input element: p1_pongs_amount, .., p4_kongs_amount
	player_id = this_slider_id.charAt(1);
	this_slider = document.getElementById(this_slider_id);
	// turn "pong" into "kong" and vice versa
	char = this_slider_id.charAt(3) == 'p' ? 'k': 'p';
	other_slider_id = this_slider_id.slice(0,2)+'_'+char+this_slider_id.slice(4);
	other_slider = document.getElementById(other_slider_id);
	sum = Number(this_slider.value) + Number(other_slider.value);
	if(sum < 1) {
		// both sliders at 0
		this_slider.setAttribute('max', 4);
		other_slider.setAttribute('max', 4);
	}
	else if( sum > 4) {
		// illegal combination: Reset both sliders
		console.log('Pongs+Kongs > 4');
		other_slider.value = 0;
		this_slider.value = 0;
		other_slider.setAttribute('max', 4);
		this_slider.setAttribute('max', 4);
		// Re-hide detail selections and set the counters to 0
		expandArea('p' + player_id + '_num_pongs', this_slider_id);
		expandArea('p' + player_id + '_num_kongs', this_slider_id);
		showRangeValue('p' + player_id + '_pongs_amount', 'value_pongs_' + player_id);
		showRangeValue('p' + player_id + '_kongs_amount', 'value_kongs_' + player_id);

	}
	else if(this_slider.value == 0) {
		console.log('Pongs+Kongs == 0');
		other_slider.setAttribute('max', 4);
	}
	else if(other_slider.value == 0) {
		this_slider.setAttribute('max', 4);
	}
	else {
		// both have a non-zero value
		console.log('Both Pong and Kong detected');
		this_slider.setAttribute('max', 4-other_slider.value);
		other_slider.setAttribute('max', 4-this_slider.value);
	}
}

/*
 * Show/Hide div#own_flowers_<id>
 * Show only if total flowers > 0
 */
function revealFlowers(id) {
	flowers = document.getElementById('flowers_'+id);
	own = document.getElementById('ownflowers_'+id);
	if (flowers.value > 0) {
		own.style.display = 'block';
	}
	else {
		own.style.display = 'none';
	}
}


/*
 * Output the current value of an input[type="range"] element
 * into a given container element
 */
function showRangeValue(slider_element, result_element) {
	source_value = document.getElementById(slider_element).value;
	target = document.getElementById(result_element);
	target.innerText = source_value; // !!!!! .innerText, nicht .innerHtml
}


/*
 * Set all containers showing slider values to 0
 */
function killAllRangeValues() {

	elements = document.getElementsByClassName('value_container');
	for(i=0;i<elements.length;i++) {
		elements[i].innerText = 0;
	}
}


/*
 * Get the values of all the appropriate sliders;
 * Add the values up;
 * Set the "max" attribute on all the sliders
 * according to the possibly remaining tiles;
 * Show the checkbox for a full sequence of flowers
 * only if:
 * 	there are at least 4 flowers
 * 	and at least 1 own flower
 *  and at most 6 flowers
 *  (7 or 8 flowers means 1 or 2 sequences no matter what,
 *   no checkbox necessary).
 */
function disableFlowers(thisplayer) {
	let ff = document.getElementById('flowers_'+thisplayer);
	let f1 = document.getElementById('flowers_1');
	let f2 = document.getElementById('flowers_2');
	let f3 = document.getElementById('flowers_3');
	let f4 = document.getElementById('flowers_4');
	let own_flowers = document.getElementById('own_flowers_'+thisplayer);
	let sequence = document.getElementById('flower_sequence_'+thisplayer);
	let sequence_container = document.getElementById('flower_sequence_container_'+thisplayer);
	console.log(ff);
	// Limit the sum of values of all flower sliders to 8.
	if(Number(f1.value) + Number(f2.value) + Number(f3.value) + Number(f4.value) > 8) {
		ff.value = ff.value -1;
		// Update all value displays
		for(i=1; i<5; i++) {
			showRangeValue('flowers_'+i, 'value_flowers_'+i);
		}
		disableFlowers(thisplayer); // Do it again
	}
	// Own flowers must be less or equal to flowers
	if(own_flowers.value > Math.min(ff.value, 2)) {
		own_flowers.value = Math.min(ff.value, 2);
		showRangeValue('own_flowers_'+thisplayer, 'value_own_flowers_'+thisplayer);
	}

	// Show or hide the checkbox
	if((ff.value > 3 && own_flowers.value > 0) || (ff.value > 6)) {
		sequence_container.style.display = 'block';
	}
	else {
		sequence_container.style.display = 'none';
		sequence.checked = false;
	}
	// Auto-check the box if appropriate
	if(ff.value > 6) {
		sequence.checked = true;
		own_flowers.value = Math.min(own_flowers.value, 1);
	}
	else if(ff.value < 1) {
		own_flowers.value = 0;
		sequence.checked = false;
	}
	else if(ff.value < 4) {
		sequence.checked = false;
	}
}
function disableOwnFlowers(pid) {
	let flowers = document.getElementById('flowers_' + pid)
	let own = document.getElementById('own_flowers_' + pid);
	if(own.value > flowers.value) {
		own.value = own.value-1;
		showRangeValue('flowers_' + pid, 'value_own_flowers_' + pid);
		disableOwnFlowers(pid);
	}
}
