<?php
/* # ############################# #
 * 
 * Validation
 * pt.1: The sum of things
 * Validate whether or not too many combinations of a certain type were assigned
 */
$total_flowers = $total_corner_pongs = $total_corner_kongs = 0;
$total_trump_pongs = $total_trump_kongs = 0;
foreach($player_list as $p) {
	$total_flowers = $total_flowers + $p->num_flowers;
	if(isset($p->kongs)) {
		foreach($p->kongs as $kong) {
			if($kong['corner']) $total_corner_kongs++;
			if($kong['trump']) $total_trump_kongs++;
		}
	}
	if(isset($p->pongs)) {
		foreach($p->pongs as $pong) {
			if($pong['corner']) $total_corner_pongs++;
			if($pong['trump']) $total_trump_pongs++;
		}
	}
}
// Validate the amount of total flowers assigned
if($total_flowers > 8) $error .= "\nZu viele Blumen/Jahreszeiten vergeben.";
// Validate the amount of corner/trump pongs and kongs
if($total_corner_kongs + $total_corner_pongs > 6) 	$error .= "\nMehr als 6 Randpongs/kongs angegeben.";
if($total_trump_kongs + $total_trump_pongs > 7) $error .= "\nMehr als 7 Trumpfpongs/kongs angegeben.";


/* # ############################# #
 *
 * Validation
 * pt.2: Individual Impossibilities
 */
foreach($player_list as $p) {
	// Pongs + Kongs [+ Chows] >= 4
	if($p->num_pongs + $p->num_kongs > 4) {
		$error .= "\nMehr als 4 Pongs/Kongs in einer Hand angegeben.";
	}
	// Please don't have more Own Flowers than Total Flowers
	if($p->num_own_flowers > $p->num_flowers) {
		$error .= "\nMehr Eigene Blumen als Gesamtblumnen eingegeben.";
	}
	// No Pong can be both Corner and Trump
	if(isset($p->pongs)) {
		foreach($p->pongs as $pong) {
			if($pong['corner'] && $pong['trump']) $error .= "\nPong als Rand-Trumpf deklariert.";
		}
	}
	// No Pong can be both Corner and Trump
	if(isset($p->kongs)) {
		foreach($p->kongs as $kong) {
			if($kong['corner'] && $kong['trump']) $error .= "\nKong als Rand-Trumpf deklariert.";
		}
	}
}
?>
